/*
 * Decompiled with CFR 0.152.
 */
package javaxt.webservices;

import java.net.Proxy;
import javaxt.http.Request;
import javaxt.webservices.Method;
import javaxt.webservices.Parameter;
import javaxt.webservices.Parameters;
import javaxt.webservices.Service;
import javaxt.webservices.SoapException;
import javaxt.webservices.SoapResponse;
import javaxt.xml.DOM;

public class SoapRequest {
    private Request request;
    private String resultsNode;
    private String body;

    public SoapRequest(Service service, Method method, Object parameters) {
        this.resultsNode = method.getResultsNodeName();
        this.request = new Request(service.getURL());
        this.request.setHeader("Content-Type", "text/xml; charset=utf-8");
        this.request.setHeader("Accept", "text/html, text/xml, text/plain");
        String action = method.getSoapAction();
        if (action != null) {
            this.request.addHeader("SOAPAction", action);
        }
        String ns = "ns2";
        StringBuffer body = new StringBuffer();
        body.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?><soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body>");
        body.append("<" + ns + ":" + method.getName() + " xmlns:" + ns + "=\"" + service.getNameSpace() + "\">");
        if (parameters != null && method.getParameters().getArray() != null) {
            if (parameters instanceof Parameters) {
                body.append(((Parameters)parameters).toString(ns));
            }
            if (parameters instanceof Parameter) {
                Parameters params = method.getParameters();
                params.setValue((Parameter)parameters);
                body.append(params.toString(ns));
            } else if (parameters instanceof String) {
                body.append(parameters);
            } else if (parameters instanceof String[]) {
                String[] values = (String[])parameters;
                Parameter[] params = method.getParameters().getArray();
                if (params != null) {
                    for (int i = 0; i < params.length; ++i) {
                        String parameterName = params[i].getName();
                        String parameterValue = values[i];
                        body.append("<" + ns + ":" + parameterName + ">");
                        body.append(DOM.escapeXml(parameterValue));
                        body.append("</" + ns + ":" + parameterName + ">");
                    }
                }
            }
        }
        body.append("</" + ns + ":" + method.getName() + ">");
        body.append("</soap:Body></soap:Envelope>");
        this.body = body.toString();
        this.request.setHeader("Content-Length", body.length() + "");
    }

    public void setUseCache(boolean useCache) {
        this.request.setUseCache(useCache);
    }

    public void validateSSLCertificates(boolean validateCertificates) {
        this.request.validateSSLCertificates(validateCertificates);
    }

    public void setNumRedirects(int maxRedirects) {
        this.request.setNumRedirects(maxRedirects);
    }

    public void setCredentials(String username, String password) {
        this.request.setCredentials(username, password);
    }

    public void setUserName(String username) {
        this.request.setUserName(username);
    }

    public void setPassword(String password) {
        this.request.setPassword(password);
    }

    public Proxy setProxy(String proxyHost, int proxyPort) {
        return this.request.setProxy(proxyHost, proxyPort);
    }

    public Proxy setProxy(String httpProxy) {
        return this.request.setProxy(httpProxy);
    }

    public void setProxy(Proxy httpProxy) {
        this.request.setProxy(httpProxy);
    }

    public void setHeader(String key, String value) {
        this.request.setHeader(key, value);
    }

    public void addHeader(String key, String value) {
        this.request.addHeader(key, value);
    }

    public String getBody() {
        return this.body;
    }

    public SoapResponse getResponse() throws SoapException {
        this.request.write(this.body);
        return new SoapResponse(this.request.getResponse(), this.resultsNode);
    }
}

